;*
;* JAVA I/O FOR 6502
;*
	.INCLUDE	"global.inc"
;*
;* HANDY ROM ROUTINES
;*
ROM_MONITOR	EQU	$FF65
ROM_HOME	EQU	$FC58
ROM_BELL	EQU	$FF3A
ROM_COUT	EQU	$FDED
ROM_CROUT	EQU	$FD8E
ROM_CROUT1	EQU	$FD8B
ROM_PRBLNK	EQU	$F948
ROM_PRBL2	EQU	$F94A
ROM_PRBYTE	EQU	$FDDA
ROM_PRNTAX	EQU	$F941
ROM_GETLN	EQU	$FD6A
;*
;* SERIAL PORT DEFINES
;*
;HW_FLOWCTRL	EQU	1
XON	EQU	$11
XOFF	EQU	$13

	.IMPORT	HMEM_ALLOC,HMEM_LOCK,HMEM_ALLOC_FIXED,HMEM_FREE,HMEM_PTR
	.IMPORT	THREAD_YIELD,THREAD_NOTIMEOUT,THREAD_NOTIFYIO,THREAD_WAITIO,SYSTEM_TIC,CURRENT_THREAD
	.IMPORT	THROW_IOEXCPTN,THROW_INTERNALERR,THREAD_TRACE
	.IMPORT	MEMCPY
	.EXPORT	IO_INIT,IODEV_INIT,HOME,GETLN,PRNTAX,CROUT,PRBYTE,COUT
	.EXPORT	PUTS
	.EXPORT	PUTSLN
	.EXPORT	PRSTR,PRSTRLN,PRHSTR,PRHSTRLN
	.EXPORT	KBWAIT
	.EXPORT	PREFIX_GET,PREFIX_SET
	.EXPORT	FILE_OPEN,FILE_SETBUFFER,FILE_READ,FILE_CLOSE,FILE_BLOAD

	.SEGMENT "INIT"
IO_INIT:	LDA	#$00
	STA	TYPEBUFFLEN
	STA	LCIN_MASK
	LDA	MACHID		; CHECK FOR II OR II+
	AND	#$88
	BEQ	:+
	LDA	#$20
:	EOR	#$DF		; LCOUT_MASK = $DF FOR II & II+, $FF FOR IIE & IIC
	STA	LCOUT_MASK
	LDX	#$0E
:	LDA	#<UNIMPL_DRVR		; FILL DRIVER TABLE WITH UNIMPLEMENTED DRIVER
	STA	LINK_DEVREAD,X
	STA	LINK_DEVWRITE,X
	STA	LINK_DEVCTRL,X
	LDA	#>UNIMPL_DRVR
	STA	LINK_DEVREAD+1,X
	STA	LINK_DEVWRITE+1,X
	STA	LINK_DEVCTRL+1,X
	DEX
	DEX
	BPL	:-
	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$40		; ALLOC INTERRUPT
	.ADDR	ALLOCINTPARMS
.IFDEF	DEBUG	
	BCC	:+
	JSR	PUTSLN
	.ASCIIZ	"FAILED TO ALLOCATE INTERRUPT"
:
.ENDIF
	BIT	LCBNK2
	BIT	LCBNK2
	RTS
ALLOCINTPARMS:	.BYTE	$02
	.BYTE	$00		; INT NUM
	.ADDR	IO_INTERRUPT		; INT CODE
;*
;* IO DEVICE INIT
;*
IODEV_INIT:	PHP
	SEI			; TURN OFF INTERRUPTS
	LDA	#<SW_TIMER		; CREATE EXTERNAL LINKEAGE TO YIELD AT $300
	STA	LINK_YIELD
	LDA	#>SW_TIMER
	STA	LINK_YIELD+1
	LDA	#<PRODOS_MLI
	STA	LINK_PRODOS
	LDA	#>PRODOS_MLI
	STA	LINK_PRODOS+1
	LDA	#<PRHSTR
	STA	LINK_SCRPRT
	LDA	#>PRHSTR
	STA	LINK_SCRPRT+1
	LDA	#<PRHSTRLN
	STA	LINK_SCRPRTLN
	LDA	#>PRHSTRLN
	STA	LINK_SCRPRTLN+1
	LDA	#<CON_DRIVER		; LOAD CONSOLE DRIVER
	LDX	#>CON_DRIVER
	LDY	#$03		; IN SLOT 3
	JSR	LOAD_DRIVER
	LDA	#$01
	LDX	#$31		; LOOK FOR SSC
	JSR	SCAN_SLOTS
	BCS	:+
	TAY
	LDA	#<SSC_DRIVER		; LOAD SUPER SERIAL CARD DRIVER
	LDX	#>SSC_DRIVER
	JSR	LOAD_DRIVER
	LDA	LOADSLOT
	STA	SSCSLOT
NEXTSSC:	INC	LOADSLOT
	LDA	LOADSLOT
	CMP	#$08
	BCS	:+
	LDX	#$31		; LOOK FOR MORE SSC
	JSR	SCAN_SLOTS
	BCS	:+
	LDA	SSCSLOT		; COPY DRIVER ENTRPOINTS TO ANOTHER SLOT
	ASL
	TAX
	LDA	LOADSLOT
	ASL
	TAY
	LDA	LINK_DEVREAD,X
	STA	LINK_DEVREAD,Y
	LDA	LINK_DEVREAD+1,X
	STA	LINK_DEVREAD+1,Y
	LDA	LINK_DEVWRITE,X
	STA	LINK_DEVWRITE,Y
	LDA	LINK_DEVWRITE+1,X
	STA	LINK_DEVWRITE+1,Y
	LDA	LINK_DEVCTRL,X
	STA	LINK_DEVCTRL,Y
	LDA	LINK_DEVCTRL+1,X
	STA	LINK_DEVCTRL+1,Y
	LDA	LINK_DEVIRQ,X
	STA	LINK_DEVIRQ,Y
	LDA	LINK_DEVIRQ+1,X
	STA	LINK_DEVIRQ+1,Y
	JMP	NEXTSSC		; LOOK FOR ALL OF THEM
:	LDX	#$20		; LOOK FOR MOUSE
	LDA	#$01
	JSR	SCAN_SLOTS
	BCS	:+
	PHA			; SAVE SLOT
	LDY	#$13
	LDA	(TMPTR),Y
	STA	MOUSE_IRQ+1		; FIXUP IRQ HANDLER
	STX	MOUSE_IRQ+2
	TXA
	AND	#$0F
	STA	MOUSE_SLOT
	TAY
	LDA	#IOCTL_DISABLE
	JSR	MOUSE_CTRL
	PLA
	TAY
	LDA	#<MOUSE_DRIVER		; LOAD MOUSE DRIVER
	LDX	#>MOUSE_DRIVER
	JSR	LOAD_DRIVER
	LDX	LOADSLOT		; MOVE IRQ TO TIMER IRQ
	LDA	LINK_DEVIRQ,X
	STA	LINK_TIMERIRQ
	LDA	LINK_DEVIRQ+1,X
	STA	LINK_TIMERIRQ+1
	LDA	#$00
	STA	LINK_DEVIRQ,X
	STA	LINK_DEVIRQ+1,X
.IFDEF	DEBUG_BREAK
	LDA	#<CHK_KEYBD		; REMOVE SOFTWARE TIMER
	STA	LINK_YIELD
	LDA	#>CHK_KEYBD
	STA	LINK_YIELD+1
.ELSE
	LDA	#<THREAD_YIELD		; REMOVE SOFTWARE TIMER
	STA	LINK_YIELD
	LDA	#>THREAD_YIELD
	STA	LINK_YIELD+1
.ENDIF
	JSR	PUTSLN
	.ASCIIZ	"VBlank timer active"
:	PLP
	RTS
;
; SCAN SLOTS FOR MATCHING CARD ID
; ENTRY: A = START SLOT SCAN
;        X = CARD ID
; EXIT:  A = SLOT # :: C = 0
;        X = SLOT PAGE
;
SCAN_SLOTS:	ORA	#$C0
	STA	TMPTR+1
	LDA	#$00
	STA	TMPTR
CHKSIG:	LDY	#$05
	LDA	(TMPTR),Y
	CMP	#$38		; LOOK FOR PASCAL COMPAT SIG
	BNE	:+
	LDY	#$07
	LDA	(TMPTR),Y
	CMP	#$18
	BNE	:+
	LDY	#$0B
	LDA	(TMPTR),Y
	CMP	#$01
	BNE	:+
	LDY	#$0C
	TXA			; LOOK FOR MATCHING ID
	CMP	(TMPTR),Y
	BNE	:+
	LDA	TMPTR+1
	TAX
	AND	#$07
	CLC
	RTS
:	INC	TMPTR+1
	LDA	TMPTR+1
	CMP	#$C8
	BCC	CHKSIG
	SEC
	RTS
;
; LOAD DEVICE DRIVER AND INSERT INTO LINK TABLE
; ENTRY: AX = DRIVER ADDRESS
;         Y = SLOT #
;
LOAD_DRIVER:	STA	LDPTR		; DRIVER ENTRIES
	STX	LDPTR+1
	CLC
	ADC	#$0A		; START OF CODE
	STA	SRCADDR
	BCC	:+
	INX
:	STX	SRCADDR+1
	TYA
	ASL
	STA	LOADSLOT
	LDY	#$01		; GET DRIVER SIZE
	LDA	(LDPTR),Y
	DEY
	TAX
	LDA	(LDPTR),Y
	JSR	HMEM_ALLOC		; ALLOC THE MEMORY
	JSR	HMEM_LOCK		; AND LOCK IT - FOREVER
	STA	DSTADDR
	STX	DSTADDR+1
	LDX	LOADSLOT
	LDY	#$02		; INSERT DEVICE READ ROUTINE
	CLC
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVREAD,X
	LDA	DSTADDR+1
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVREAD+1,X
	LDA	DSTADDR		; INSERT DEVICE WRITE ROUTINE
	CLC
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVWRITE,X
	LDA	DSTADDR+1
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVWRITE+1,X
	LDA	DSTADDR		; INSERT DEVICE CTRL ROUTINE
	CLC
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVCTRL,X
	LDA	DSTADDR+1
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVCTRL+1,X
	LDA	DSTADDR		; INSERT DEVICE IRQ ROUTINE
	CLC
	ADC	(LDPTR),Y
	INY
	STA	LINK_DEVIRQ,X
	LDA	DSTADDR+1
	ADC	(LDPTR),Y
	STA	LINK_DEVIRQ+1,X
	LDY	#$01		; GET DRIVER SIZE
	LDA	(LDPTR),Y
	DEY
	TAX
	LDA	(LDPTR),Y
	JMP	MEMCPY		; MOVE DRIVER TO LOCKED MEM AND DONE	
LOADSLOT:	.BYTE	$00
SSCSLOT:	.BYTE	$00
;*
;* CONSOLE DEVICE DRIVER
;*
CON_DRIVER:
CON_DRVR_SZ:	.WORD	CON_DRVR_END - CON_DRVR_START
CON_READ_OFS:	.WORD	CON_READ     - CON_DRVR_START
CON_WRITE_OFS:	.WORD	CON_WRITE    - CON_DRVR_START
CON_CTRL_OFS:	.WORD	CON_CTRL     - CON_DRVR_START
CON_IRQ_OFS:	.WORD	CON_IRQ      - CON_DRVR_START
CON_DRVR_START:
;
; READ CHARACTER FROM KEYBOARD BUFFER, WAITING IF NONE AVAILABLE
; EXIT: A = CHARACTER
;
CON_READ:	SEI
	LDX	TYPEBUFFLEN
	BNE	:+
	CLI
	LDY	CURRENT_THREAD
	JSR	THREAD_NOTIMEOUT
	LDY	#$03		; LOAD SLOT #
	JSR	THREAD_WAITIO
	CLC
	BCC	CON_READ
:	LDY	TYPEBUFF		; SAVE OLDEST CHAR
	DEC	TYPEBUFFLEN
	BEQ	CONRDEXIT
	LDX	#$00
:	LDA	TYPEBUFF+1,X		; SHIFT TYPE AHEAD BUFFER DOWN
	STA	TYPEBUFF,X
	INX
	CPX	TYPEBUFFLEN
	BNE	:-
CONRDEXIT:	TYA
	CLI
	RTS
;
; WRITE TO CONSOLE
;
CON_WRITE:	JMP	COUT
;
; CONSOLE DEVICE CONTROL
;
CON_CTRL:	LDX	#$00
	CMP	#IOCTL_AVAIL
	BNE	:+
	LDA	TYPEBUFFLEN		; RETURN AVAILABLE KEYBOARD CHARACTERS
	CLC
	RTS
:	CMP	#IOCTL_SPACE
	BNE	:+
	LDA	#$01
	CLC
	RTS
:	CMP	#CONCTL_HOME
	BNE	:+
	LDA	MACHID
	BMI	ROMHOME
	AND	#$02
	BEQ	ROMHOME
	LDA	#$0C		; CTRL-L = HOME CHARACTER
	JSR	COUT
	CLC
	RTS
ROMHOME:	JSR	HOME
	CLC
	RTS
:	CMP	#CONCTL_TEXT80
	BNE	:+
	LDA	MACHID		; CHECK FOR 80 COL CARD INSTALLED
	AND	#$02
	BEQ	CONCTLBAD
	SEI			; NO INTS FOR SETUP
	LDA	#$00
	TAX
	TAY
	BIT	ROMIN
	JSR	$C300
	LDA	MACHID
	BMI	ROMHOME
	LDA	#$02		; ADJUST VIDEX PARAMETERS
	STA	$C0B0
	LDA	#$5E
	STA	$C0B1
	LDA	#$07
	STA	$C0B0
	LDA	#$1B
	STA	$C0B1
	LDA	#$08
	STA	$C0B0
	LDA	#$01
	STA	$C0B1
	LDA	#$FF		; CLEAR LOWER-CASE MASK
	STA	LCOUT_MASK
	LDA	#$0C		; CTRL-L = HOME CHARACTER
	JSR	COUT
	CLC
	RTS
:	CMP	#IOCTL_ID
	BEQ	:+
CONCTLBAD:	SEC
	RTS
:	LDA	MACHID
	AND	#$02
	BEQ	CONCTLOK		; ID $00 = NO 80 COLUMN
	LDA	MACHID		; ID $80 = II, II+ 80 COLUMN
	AND	#$80		; ID $88 = IIE, IIC 80 COLUMN
	BEQ	:+
	LDA	#$08
:	ORA	#$80
CONCTLOK:	CLC
	RTS
;
; KEYBOARD IRQ.  FAKED ON II, II+, AND IIE - THIS WILL ACTUALLY BE AN IRQ ON IIC
;
CON_IRQ:	LDA	KEYBD
	BMI	SPCLKEYS
	SEC
	RTS
SPCLKEYS:	BIT	CLRKBD		; CLEAR KEYBOARD STROBE
	AND	#$7F
.IFDEF	DEBUG_BREAK
	CMP	#$03		; CHECK FOR CTRL-C
	BNE	NOBREAK
	PHP
	SEI
	BIT	CLRKBD
	LDA	#$4C
	STA	$03F8
	LDA	#<BREAKOUT
	STA	$03F9
	LDA	#>BREAKOUT
	STA	$03FA
	BIT	$C054		; SET TEXT MODE
	BIT	$C051
	JSR	HOME
	JSR	THREAD_TRACE
	BIT	ROMIN
	JMP	$FF65
BREAKOUT:	PLA			; REMOVE RETURN ADDRESS
	PLA
	BIT	CLRKBD
	BIT	LCBNK2
	BIT	LCBNK2
	PLP
	SEC
	RTS
NOBREAK:
.ENDIF
	LDY	MACHID		; IS IT A II OR II+?
	BMI	TYPEAHEAD		; NOPE
	CMP	#$01		; CHECK FOR CTRL-A
	BNE	:+
	LDA	#$20		; TOGGLE LOWERCASE MASK
	EOR	LCIN_MASK		; CTRL-A = CAPS LOCK
	STA	LCIN_MASK
	SEC			; EAT KEYPRESS
	RTS
:	CMP	#$0B		; CTRL-K -> [
	BEQ	:+
	CMP	#$0C		; CTRL-L -> \
	BEQ	:+
	CMP	#$0F		; CTRL-O -> _
	BNE	CHKKEYLOWER
:	ORA	#$50
CHKKEYLOWER:	CMP	#$40
	BCC	TYPEAHEAD
	ORA	LCIN_MASK
TYPEAHEAD:	LDX	TYPEBUFFLEN
	CPX	#TYPEBUFFMAX
	BCS	TYPEBUFFULL
	STA	TYPEBUFF,X
	INC	TYPEBUFFLEN
TYPEBUFFULL:	CLC
	RTS
CON_DRVR_END	EQU	*
;*
;* SUPER SERIAL CARD DEVICE DRIVER
;*
SSC_DRIVER:
SSC_DRVR_SZ:	.WORD	SSC_DRVR_END - SSC_DRVR_START
SSC_READ_OFS:	.WORD	SSC_READ     - SSC_DRVR_START
SSC_WRITE_OFS:	.WORD	SSC_WRITE    - SSC_DRVR_START
SSC_CTRL_OFS:	.WORD	SSC_CTRL     - SSC_DRVR_START
SSC_IRQ_OFS:	.WORD	SSC_IRQ      - SSC_DRVR_START
SSC_DRVR_START:
SSC_READ:	TYA			; READ CHARACTER FROM BUFFER
	TAX
SSCRRETRY:	SEI
	LDA	$0578,X		; GET INDEX
	CMP	$05F8,X		; CHECK FOR EMPTY
	BNE	:+
	CLI
	TXA
	PHA
	LDY	CURRENT_THREAD
	JSR	THREAD_NOTIMEOUT
	PLA
	TAY			; LOAD SLOT #
	PHA
	JSR	THREAD_WAITIO
	PLA
	TAX
	LDA	$07F8,X
	AND	#$01		; PORT STILL ACTIVE?
	BNE	SSCRRETRY
	RTS			; NOPE
:	LDY	$0478,X		; SET UP BUFFER POINTERS
	STY	TMPTR
	LDY	$04F8,X
	STY	TMPTR+1
	TAY
	LDA	(TMPTR),Y
	INC	$0578,X		; INCREMENT GET INDEX
	LDY	$07F8,X
	BMI	:+		; CHECK FOR XON/XOFF
	CLC
	RTS
:	PHA
	TYA
	AND	#$40
	BEQ	SSCXONEXIT
	LDA	$05F8,X
	SEC
	SBC	$0578,X
	CMP	#$10
	BCS	SSCXONEXIT
	TYA
	AND	#$BF
	STA	$07F8,X
	LDY	SLOT2IO,X
.IFDEF	HW_FLOWCTRL
	LDA	$C08A,Y		; ENABLE RECEIVER
	ORA	#$01
	STA	$C08A,Y
.ELSE
:	LDA	$C089,Y
	AND	#$10
	BEQ	:-
	LDA	#XON		; SEND XON
	STA	$C088,Y
.ENDIF
	SEI
	TXA
	JSR	THREAD_NOTIFYIO		; WAKE UP ANY WAITING WRITES
SSCXONEXIT:	PLA
	CLC
	RTS
SSC_WRITE:	PHA			; WRITE CHARACTER TO SERIAL PORT
	LDA	$07F8,Y
	BPL	SSCWRETRY		; CHECK FOR FLOW CONTROL
	AND	#$40
	BEQ	SSCWRETRY
	TYA
	PHA
	LDY	CURRENT_THREAD
	JSR	THREAD_NOTIMEOUT
	PLA
	TAY			; LOAD SLOT #
	PHA
	JSR	THREAD_WAITIO
	PLA
	TAY
	LDA	$07F8,Y
	AND	#$01		; PORT STILL ACTIVE?
	TAX
	PLA
	DEX
	BEQ	SSC_WRITE
	RTS
SSCWRETRY:	LDX	SLOT2IO,Y
:	LDA	$C089,X		; DO THIS WITH INTS ENABLED
	AND	#$10		; SO READS DON'T GET STARVED
	BEQ	:-		; HOPEFULLY WON'T CLEAR INT BEFORE IRQ
	PLA
	STA	$C088,X
	CLC
	RTS
SSC_CTRL:	CMP	#IOCTL_AVAIL
	BNE	:+
	SEI			; AVAILABLE CHARS IN BUFFER
	LDA	$05F8,Y		; GET INDEX
	SEC
	SBC	$0578,Y		; MINUS PUT INDEX
	CLC
	RTS
:	CMP	#IOCTL_SPACE
	BNE	:+
	LDA	$07F8,Y		; CHECK FOR FLOW CONTROL
	AND	#$40
	ASL
	ASL
	ROL
	EOR	#$01
	RTS
:	CMP	#SERCTL_BAUD
	BNE	:+
	STX	TMP
	LDX	SLOT2IO,Y
	LDA	$C08B,X
	AND	#$E0
	ORA	TMP
	EOR	#$10
	STA	$C08B,X
	CLC
	RTS
:	CMP	#SERCTL_DATABITS
	BNE	:+
	TXA
	ASL
	ASL
	ASL
	ASL
	ASL
	STA	TMP
	LDX	SLOT2IO,Y
	LDA	$C08B,X
	AND	#$9F
	ORA	TMP
	STA	$C08B,X
	CLC
	RTS
:	CMP	#SERCTL_PARITYBITS
	BNE	:+
	TXA
	ASL
	ASL
	ASL
	ASL
	ASL
	STA	TMP
	LDX	SLOT2IO,Y
	LDA	$C08A,X
	AND	#$1F
	ORA	TMP
	STA	$C08A,X
	CLC
	RTS
:	CMP	#SERCTL_STOPBITS
	BNE	:+
	TXA
	LSR
	ROR
	STA	TMP
	LDX	SLOT2IO,Y
	LDA	$C08B,X
	AND	#$7F
	ORA	TMP
	STA	$C08B,X
	CLC
	RTS
:	CMP	#SERCTL_XONXOFF
	BNE	:+
	LDA	$07F8,Y
	AND	#$7F
	STA	$07F8,Y
	TXA
	LSR
	LDA	#$00
	ROR
	ORA	$07F8,Y
	STA	$07F8,Y
	CLC
	RTS
:	CMP	#IOCTL_INBUFFL
	BNE	:+
	TXA
	STA	$0478,Y
	CLC
	RTS
:	CMP	#IOCTL_INBUFFH
	BNE	:+
	TXA
	STA	$04F8,Y
	CLC
	RTS
:	CMP	#IOCTL_INBUFFSZL
	BNE	:+
:	CMP	#IOCTL_INBUFFSZH
	BNE	:+
:	CMP	#IOCTL_INIT
	BNE	:+
	LDA	#$00		; ZERO OUT INBUFF GET/PUT INDECES
	STA	$0578,Y
	STA	$05F8,Y
	STA	$07F8,Y		; CLEAR FLAGS
	LDX	SLOT2IO,Y
	LDA	#$00
	STA	$C089,X		; PROGRAMMED RESET
	CLC
	RTS
:	CMP	#IOCTL_ENABLE
	BNE	:+
	LDX	SLOT2IO,Y
	LDA	$C08A,X
	AND	#$F0		; ENABLE XFER & INTS
	ORA	#$09
	STA	$C08A,X
	LDA	$07F8,Y		; SET ENABLE FLAG
	ORA	#$01
	STA	$07F8,Y
	CLC
	RTS
:	CMP	#IOCTL_DISABLE
	BNE	:+
	LDX	SLOT2IO,Y
	LDA	$C08A,X
	AND	#$F0		; DISABLE XFER & INTS
	STA	$C08A,X
	LDA	$07F8,Y		; CLEAR ENABLE FLAG
	AND	#$FE
	STA	$07F8,Y
	TYA
	JSR	THREAD_NOTIFYIO		; WAKE UP ANY WAITING THREADS
	CLC
	RTS
:	CMP	#IOCTL_ID
	BEQ	:+
	SEC
	RTS
:	LDA	#$31		; SSC ID
	CLC
	RTS
SSC_IRQ:	TAX			; A = IRQ SLOT #
	LDY	SLOT2IO,X
	LDA	$C089,Y		; LOAD STATUS
	BMI	SSCSERVINT		; IRQ = BIT 7
	SEC
	RTS
SSCSERVINT:	AND	#$08		; RECEIVE DATA
	BEQ	SSCEXIT
	LDA	$C088,Y		; READ CHARACTER
	LDY	$0478,X		; SET UP BUFFER POINTERS
	STY	TMPTR
	LDY	$04F8,X
	STY	TMPTR+1
	LDY	$05F8,X		; PUT INDEX
	STA	(TMPTR),Y		; STORE CHAR IN BUFF
	INY
	TYA
	CMP	$0578,X		; CHECK FOR FULL
	BEQ	SSCEXIT		; FULL, SKIP INC
	STA	$05F8,X		; INC PUT INDEX
	LDY	$07F8,X		; CHECK FOR XON/XOFF ENABLE
	BMI	:+
SSCEXIT:	CLC
	RTS
:	SEC
	SBC	$0578,X
	CMP	#$E0		; ABOVE THRESHOLD?
	BCC	SSCEXIT+1
	TYA
	AND	#$40		; ALREAD SENT XOFF?
	BNE	SSCEXIT
	LDY	SLOT2IO,X
.IFDEF	HW_FLOWCTRL
	LDA	$C08A,Y		; DISABLE RECEIVER
	AND	#$FE
	STA	$C08A,Y
.ELSE
:	LDA	$C089,Y
	BMI	SSCSERVINT
	AND	#$10
	BEQ	:-
	LDA	#XOFF		; SEND XOFF
	STA	$C088,Y
.ENDIF
	LDA	$07F8,X
	ORA	#$40		; SET XOFF FLAG
	STA	$07F8,X
	CLC
	RTS
SSC_DRVR_END	EQU	*
;*
;* MOUSE DEVICE DRIVER
;*
MOUSE_DRIVER:
MOUSE_DRVR_SZ:	.WORD	MOUSE_DRVR_END - MOUSE_DRVR_START
MOUSE_READ_OFS:	.WORD	MOUSE_READ     - MOUSE_DRVR_START
MOUSE_WRITE_OFS: .WORD	MOUSE_WRITE    - MOUSE_DRVR_START
MOUSE_CTRL_OFS:	.WORD	MOUSE_CTRL     - MOUSE_DRVR_START
MOUSE_IRQ_OFS:	.WORD	MOUSE_IRQ      - MOUSE_DRVR_START
MOUSE_DRVR_START:
MOUSE_READ:
MOUSE_WRITE:	SEC
	RTS
MOUSE_CTRL:	CMP	#MOUSECTL_CALLFW
	BNE	:+
	PHA
CALLMOUSEFW:	LDA	#$00
	STA	OPJMP
	TYA
	ORA	#$C0
	STA	OPJMP+1
	TXA
	TAY
	LDA	(OPJMP),Y		; GET ENTRYPOINT OFFSET
	STA	OPJMP
	LDX	OPJMP+1
	TXA
	ASL
	ASL
	ASL
	ASL
	TAY
	PLA
	SEI
	JMP	(OPJMP)		; CALL FIXED UP FUNCTION POINTER
:	CMP	#IOCTL_ENABLE
	BNE	:+
	TYA
	ASL
	TAX
	LDA	LINK_DEVCTRL,X
	CLC
	ADC	#<(MOUSE_IRQ-MOUSE_CTRL)
	STA	LINK_TIMERIRQ
	LDA	LINK_DEVCTRL+1,X
	ADC	#>(MOUSE_IRQ-MOUSE_CTRL)
	STA	LINK_TIMERIRQ+1
.IFDEF	DEBUG_BREAK
	LDA	#<CHK_KEYBD		; REMOVE SOFTWARE TIMER
	STA	LINK_YIELD
	LDA	#>CHK_KEYBD
	STA	LINK_YIELD+1
.ELSE
	LDA	#<THREAD_YIELD		; REMOVE SOFTWARE TIMER
	STA	LINK_YIELD
	LDA	#>THREAD_YIELD
	STA	LINK_YIELD+1
.ENDIF
	LDA	#$0F		; TURN MOUSE INTS ON
	PHA
	LDX	#$12		; FW INDEX FOR SETMOUSE
	BNE	CALLMOUSEFW
:	CMP	#IOCTL_DISABLE
	BNE	:+
	LDA	$07F8,Y
	AND	#$08		; TURN MOUSE OFF
	PHA
	LDX	#$12		; FW INDEX FOR SETMOUSE
	BNE	CALLMOUSEFW
:	CMP	#MOUSECTL_NOIRQ		; UNINSTALL IRQ HANDLER
	BNE	:+
	SEI
	LDA	#<SW_TIMER		; RE-INSTALL SW TIMER
	STA	LINK_YIELD
	LDA	#>SW_TIMER
	STA	LINK_YIELD+1
	LDA	#$00
	STA	LINK_TIMERIRQ		; CLEAR TIMER IRQ VECTOR
	STA	LINK_TIMERIRQ+1
	PHA			; DISABLE ALL MOUSE INTS
	LDX	#$12		; FW INDEX FOR SETMOUSE
	BNE	CALLMOUSEFW
:	CMP	#IOCTL_ID
	BEQ	:+
	SEC
	RTS
:	LDA	#$20		; MOUSE ID
	CLC
	RTS
;
; VBLANK TIMER AND MOUSE IRQ
;
MOUSE_IRQ:	JSR	$C400
	BCS	NOVBLEXIT		; NOT MOUSE INT
	LDY	MOUSE_SLOT		; CHECK MOUSE INT CAUSE
	LDA	$0778,Y
	AND	#$0A		; ANYTHING MOUSEY RESPONSIBLE?
	BEQ	NOVBLEXIT		; NO
	AND	#$08		; WAS IT VLB?
	BEQ	VBLEXIT		; NOPE, MOVE
VBLTIC:	LDX	#$00
	LDA	#$11		; 17 MSEC (2/3 OF THE TIME)
	DEC	TIMERADJUST
	BNE	:+
	LDA	#$03
	STA	TIMERADJUST
	LDA	#$10		; 16 MSEC (1/3 OF THE TIME)
:	JSR	SYSTEM_TIC
VBLEXIT:	CLC
	RTS
NOVBLEXIT:	LDA	IRQ_SERVICED		; HACK FOR MOUSE INTS THAT STOP
	BEQ	VBLTIC		; REGISTERING CORRECTLY
	CLC
	RTS
MOUSE_DRVR_END	EQU	*
;*
;* WRAPPERS FOR ROM ROUTINES
;*
GETLN:	BIT	ROMIN
	JSR	ROM_GETLN
	JMP	SETLCBNK2
	
	.CODE

HOME:	BIT	ROMIN
	JSR	ROM_HOME
	JMP	SETLCBNK2
PRNTAX:	BIT	ROMIN
	JSR	ROM_PRNTAX
	JMP	SETLCBNK2
PRBYTE:	BIT	ROMIN
	JSR	ROM_PRBYTE
	JMP	SETLCBNK2
CROUT:	LDA	#$0D
COUT:	CMP	#$60		; LOWERCASE CHARACTER?
	BCC	:+
	AND	LCOUT_MASK		; APPLY LOWER->UPPER CONVERSION
:	ORA	#$80
	PHA
	LDA	MACHID
	BMI	:+		; SKIP FOR IIE/IIC
	LDA	$37
	CMP	#$C3		; ARE WE USING 80 COL CARD?
	BNE	:+
	STA	$07F8		; SET MSLOT FOR INT HANDLING
 :	PLA
	BIT	ROMIN
	JSR	ROM_COUT
SETLCBNK2:	PHP
	SEI			; THIS CANNOT BE INTERRUPTED
	BIT	LCBNK2
	BIT	LCBNK2
	PLP
	RTS
;
; PRINT ASCIIZ STRING FOLLOWING JSR PUTS
;
PUTSLN:	LDX	#$0D
	BNE	:+
PUTS:	LDX	#$00
:	PLA
	STA	TMP
	PLA
	STA	TMP+1
	LDY	#$00
PUTS_LP:	INC	TMP
	BNE	:+
	INC	TMP+1
:	LDA	(TMP),Y
	BEQ	PUTS_EXIT
	JSR	COUT
	JMP	PUTS_LP
PUTS_EXIT:	TXA
	BEQ	:+
	JSR	COUT
:	LDA	TMP+1
	PHA
	LDA	TMP
	PHA
	RTS
;
; PRINT STRING IN AX
;
PRHSTR:	JSR	HMEM_PTR
PRSTR:	STA	TMP
	STX	TMP+1
	LDY	#$00
	LDA	(TMP),Y
	BEQ	:+
	TAX
	INY
PRSTR_LP:	LDA	(TMP),Y
	JSR	COUT
	INY
	DEX
	BNE	PRSTR_LP
:	RTS
PRHSTRLN:	JSR	HMEM_PTR
PRSTRLN:	JSR	PRSTR
	JSR	CROUT
	RTS
;
; WAIT FOR KEYPRESS
;
KBWAIT:	LDA	KEYBD
	BPL	KBWAIT
	BIT	CLRKBD
	RTS
;*
;* I/O INTERRUPT ROUTINE
;*
IO_INTERRUPT:	CLD
	LDY	#$00
IRQRECHECK:	STY	IRQ_SERVICED
	LDY	#$02			; SLOT #1 * 2
FNDIRQPROC:	LDA	LINK_DEVIRQ+1,Y
	BEQ	NXTIRQPROC
	STA	IRQ_PROC+1
	LDA	LINK_DEVIRQ,Y
	STA	IRQ_PROC
	STY	IRQ_SLOT
	TYA
	LSR
	JSR	CALLIRQPROC
	BCS	:+
	LDA	IRQ_SLOT
	LSR
	JSR	THREAD_NOTIFYIO
	INC	IRQ_SERVICED
:	LDY	IRQ_SLOT	
NXTIRQPROC:	INY
	INY
	CPY	#$10
	BCC	FNDIRQPROC
	LDA	LINK_TIMERIRQ+1		; INTERRUPT NOT HANDLED
	BNE	:+
	CLC
	RTS
:	STA	IRQ_PROC+1		; TRY TIMER PROC IF INSTALLED
	LDA	LINK_TIMERIRQ
	STA	IRQ_PROC
	LDA	IRQ_SERVICED		; CHECK FLAG FOR TIMER SERVICE
	BMI	IRQEXIT
	JSR	CALLIRQPROC
	LDY	IRQ_SERVICED
	BEQ	:+
IRQEXIT:	CLC
	RTS
:	LDY	#$80
	BMI	IRQRECHECK		; CHECK FOR ANY MORE
CALLIRQPROC:	JMP	(IRQ_PROC)
;
; UNIMPLEMENTED DRIVER PROC
;
UNIMPL_DRVR:	SEC
	RTS
;
; SOFTWARE IMPLEMENTED (FAKED) INTERRUPT ROUTINES
;
SW_TIMER:	LDA	OPCNT
	EOR	#$FF
	CLC
	ADC	TIMERADJUST
	STA	TIMERADJUST
	BCC	CHK_KEYBD
	LDX	#$00
	LDA	#$30
	JSR	SYSTEM_TIC		; INCREMENT SYSTEM TICS BASED ON OPCNT
CHK_KEYBD:	LDA	KEYBD		; CHECK FOR PENDING KEYPRESS
	BMI	FAKEKEYBDIRQ
	JMP	THREAD_YIELD
FAKEKEYBDIRQ:	PHP			; SAVE FLAGS
	SEI			; MAKE SURE NO REAL INTERRUPTS HAPPEN
	LDX	#$06		; SAVE AND RESTORE ZP LIKE PRODOS
:	LDA	$F9,X
	STA	SAVEZPIRQ,X
	DEX
	BPL	:-
	JSR	IO_INTERRUPT
	LDX	#$06
:	LDA	SAVEZPIRQ,X
	STA	$F9,X
	DEX
	BPL	:-
	PLP			; RESTORE FLAGS
	JMP	THREAD_YIELD
;*
;* PRODOS WRAPPERS
;*
;
; CALL PRODOS MLI
; ENTRY: AX = BYTE ARRAY REFERENCE FOR PARAM BLOCK
;         Y = PRODOS COMMAND
PRODOS_MLI:	STY	MLI_CMD
	JSR	HMEM_PTR
	CLC			; SKIP ARRAY LENGTH WORD
	ADC	#$02
	BCC	:+
	INX
:	STA	MLI_PARAMS
	STX	MLI_PARAMS+1
	BIT	LCBNK1
	JSR	PRODOS
MLI_CMD:	.BYTE	$00
MLI_PARAMS:	.ADDR	$0000
	RTS
;
; GET PREFIX
; ENTRY: AX = POINTER TO PREFIX STRING
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
PREFIX_GET:	LDY	#$C7
	BNE	PREFIX_OP
;
; SET PREFIX
; ENTRY: AX = POINTER TO PREFIX STRING
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
PREFIX_SET:	LDY	#$C6
PREFIX_OP:	STY	PREFIXCMD
	STA	PREFIXPARMS+1
	STX	PREFIXPARMS+2
	BIT	LCBNK1
	JSR	PRODOS
PREFIXCMD:	.BYTE	$C7
	.ADDR	PREFIXPARMS
	JMP	SETLCBNK2
;
; OPEN FILE
; ENTRY: AX = POINTER TO FILENAME
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
FILE_OPEN:	STA	OPENPARMS+1
	STX	OPENPARMS+2
	BIT	LCBNK1
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDX	OPENPARMS+5
	STX	READPARMS+1
	STX	CLOSEPARMS+1
:	JMP	SETLCBNK2
;
; SET DATA BUFFER FOR FILE DATA.
; ENTRY: AX = DATA BUFFER POINTER
;
FILE_SETBUFFER:	STA	READPARMS+2
	STX	READPARMS+3
	CLC
	RTS
;
; CLOSE FILE
;
FILE_CLOSE:	BIT	LCBNK1
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
	JMP	SETLCBNK2
;
; READ FROM FILE
; ENTRY: AX = NUMBER OF BYTES TO READ
; EXIT:  AX = NUMBER OF BYTES ACTUALLY READ
;         C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
FILE_READ:	STA	READPARMS+4
	STX	READPARMS+5
	BIT	LCBNK1
	JSR	PRODOS
	.BYTE	$CA		; READ FILE
	.ADDR	READPARMS
	BCS	:+
	LDA	READPARMS+4
	LDX	READPARMS+5
:	JMP	SETLCBNK2
;
; READ BINARY FILE
; ENTRY: AX = POINTER TO FILE NAME
;
FILE_BLOAD:	JSR	FILE_OPEN
	LDA	OPENPARMS+5
	STA	GETEOFPARMS+1
	STA	READPARMS+1
	STA	CLOSEPARMS+1	
	JSR	PRODOS
	.BYTE	$D1		; GET EOF (FILE LEN)
	.ADDR	GETEOFPARMS
	LDA	GETEOFPARMS+2
	LDX	GETEOFPARMS+3
	JSR	FILE_READ
	JMP	FILE_CLOSE
.IF	0
;
; WRITE BINARY FILE
; ENTRY: AX = FILE NAME/ADDRESS/SIZE
;
BSAVE:	BIT	LCBNK1
	STA	LDPTR
	STX	LDPTR+1
	CLC			; SET FILENAME BUFFER
	ADC	#$02
	STA	OPENPARMS+1
	TXA
	ADC	#$00
	STA	OPENPARMS+2
	LDY	#$00		; SET DATA ADDRESS
	LDA	(LDPTR),Y
	STA	WRITEPARMS+2
	INY
	LDA	(LDPTR),Y
	STA	WRITEPARMS+3
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDA	OPENPARMS+5
	STA	WRITEPARMS+1
	STA	CLOSEPARMS+1
	JSR	PRODOS
	.BYTE	$CA		; WRITE FILE
	.ADDR	WRITEPARMS
	BCS	:+
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
:	JMP	SETLCBNK2

.ENDIF	
	.DATA
IRQ_PROC:	.ADDR	$0000
IRQ_SLOT:	.BYTE	$00
IRQ_SERVICED:	.BYTE	$00
MOUSE_SLOT:				; OVERLAP WITH SLOT2IO FOR SLOT #0 (UNUSED)
SLOT2IO:	.BYTE	$00,$10,$20,$30,$40,$50,$60,$70
TIMERADJUST:	.BYTE	$03
PREFIXPARMS:	.BYTE	$01
	.ADDR	$0000		; PATH ADDR
OPENPARMS:	.BYTE	$03
	.ADDR	$0000		; PATH ADDR
	.ADDR	$0800		; BUFF ADDR
	.BYTE	$00		; REF NUM
GETEOFPARMS:	.BYTE	$02
	.BYTE	$00		; REF NUM
	.BYTE	$00,$00,$00		; EOF L/M/H
READPARMS:	
WRITEPARMS:	.BYTE	$04
	.BYTE	$00		; REF NUM
	.ADDR	$0000		; DATA ADDR
	.ADDR	$0000		; DATA LEN
	.ADDR	$0000		; ACTUAL LEN
CLOSEPARMS:	.BYTE	$01
	.BYTE	$00		; REF NUM
SAVEZPIRQ:	.RES	6		; SAVED ZERO PAGE LOCS FOR IRQ